/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.sa.ESAXmitServiceInfoSchedulable;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.p.sa.XMITServiceInfoTransmitPanelBean;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Calendar;
import java.util.Date;

public class XMITServiceInfoTransmitTasklet
extends PanelTasklet
implements ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[XMITServiceInfoTransmitTasklet] ";
    private PanelHandler mainPanelHandler;
    private PanelHandler currentPanel;

    public XMITServiceInfoTransmitTasklet() {
        this.currentPanel = this.mainPanelHandler = new PanelHandler(){

            public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
                if (request.isDisposed() || request.isCanceled()) {
                    Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Terminating the task");
                    response.terminate();
                } else {
                    TaskActionEvent event = (TaskActionEvent)request.getData("event");
                    String elementName = event.getElementName();
                    Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]       event: " + event);
                    Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] elementName: " + elementName);
                    if (elementName.endsWith("SendButton")) {
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] <--> Got SendButton");
                        try {
                            Object schedulable = null;
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Start Service Agent SchedOps");
                            Calendar now = Calendar.getInstance();
                            Schedule schedule = new Schedule(now.getTime(), 1200000L, 1L, 1L);
                            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
                            HMC target = HMC.getHMC();
                            ScheduledOperation schedop = new ScheduledOperation(target, operation, schedule, new ServiceAgentAttr.ESAbatchXmitImmed());
                            target.getScheduler().addScheduledOperation(schedop);
                        }
                        catch (Throwable t) {
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] caught exception:");
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, t);
                        }
                        XMITServiceInfoTransmitTasklet.this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA0000E"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "Ok.button")});
                        response.noAction();
                    } else if (elementName.endsWith("SendPM")) {
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] <--> Got SendPM");
                        ServiceAgentUtils.scheduleXmitPMImmed(new ServiceAgentAttr.ESAbatchXmitPMImmed());
                        XMITServiceInfoTransmitTasklet.this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA00013"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "Ok.button")});
                        response.noAction();
                    } else if (elementName.endsWith("OKButton")) {
                        XMITServiceInfoTransmitPanelBean siPB = (XMITServiceInfoTransmitPanelBean)request.getData("bean");
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]   Frequency: " + siPB.getFrequency());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]        Time: " + siPB.getTime());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] XmitSetting: " + siPB.isXmitScheduleSetting());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] PMFrequency: " + siPB.getPMFrequency());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      PMTime: " + siPB.getPMTime());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]   PMSetting: " + siPB.isXmitPMSetting());
                        ServiceAgentUtils.setExecutionSetting(siPB.isXmitScheduleSetting());
                        ServiceAgentUtils.setExecutionFrequency(siPB.getFrequency());
                        int freq = siPB.getFrequency();
                        Calendar cal = siPB.getTime();
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] --service(OKButton)------- calendar ServiceInfo --------------");
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      HOUR_OF_DAY: " + cal.get(11));
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      ZONE_OFFSET: " + cal.get(15));
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]        getTime(): " + cal.getTime());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] -------------------------- calendar Info ---------------------");
                        Date date = new Date(cal.getTimeInMillis());
                        long ExecutionTimeOfDay = date.getTime();
                        ServiceAgentUtils.setExecutionTimeOfDay(ExecutionTimeOfDay);
                        ServiceAgentUtils.setPMExecutionSetting(siPB.isXmitPMSetting());
                        ServiceAgentUtils.setPMExecutionFrequency(siPB.getPMFrequency());
                        int PMfreq = siPB.getPMFrequency();
                        Calendar PMcal = siPB.getPMTime();
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] --service(OKButton)------- calendar PMInfo --------------");
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      HOUR_OF_DAY: " + PMcal.get(11));
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      ZONE_OFFSET: " + PMcal.get(15));
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]        getTime(): " + PMcal.getTime());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] -------------------------- calendar Info ----------------");
                        Date PMdate = new Date(PMcal.getTimeInMillis());
                        long PMExecutionTimeOfDay = PMdate.getTime();
                        ServiceAgentUtils.setPMExecutionTimeOfDay(PMExecutionTimeOfDay);
                        ServiceAgentUtils.removeScheduledOps("ESAbatchXmitPMSched");
                        if (siPB.isXmitPMSetting()) {
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] --service(OKButton)---PMdate: " + date);
                            ServiceAgentUtils.scheduleXmitPMSched(new ServiceAgentAttr.ESAbatchXmitPMSched(), PMdate, PMfreq);
                        }
                        ServiceAgentUtils.removeScheduledOps("ESAbatchXmitSched");
                        if (siPB.isXmitScheduleSetting()) {
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] --service(OKButton)---date: " + date);
                            ServiceAgentUtils.scheduleXmitSched(new ServiceAgentAttr.ESAbatchXmitSched(), date, freq);
                        }
                        response.noAction();
                    } else {
                        response.noAction();
                    }
                }
            }
        };
        Trace.trace(TRACE_MASKT, "[XMITServiceInfoTransmitTasklet] .init");
    }

    private static void setControls(XMITServiceInfoTransmitPanelBean siPB) {
        if (ServiceAgentUtils.getExecutionSetting()) {
            siPB.enableControl("Frequency");
            siPB.enableControl("Time");
        } else {
            siPB.disableControl("Frequency");
            siPB.disableControl("Time");
        }
        if (ServiceAgentUtils.getPMExecutionSetting()) {
            siPB.enableControl("PMFrequency");
            siPB.enableControl("PMTime");
        } else {
            siPB.disableControl("PMFrequency");
            siPB.disableControl("PMTime");
        }
        siPB.notifySelection("XmitPMSetting");
        siPB.notifySelection("XmitScheduleSetting");
    }

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        if (taskletRequest.isInitialRequest()) {
            XMITServiceInfoTransmitPanelBean siPB = new XMITServiceInfoTransmitPanelBean();
            long ExecutionTimeOfDay = ServiceAgentUtils.getExecutionTimeOfDay();
            Calendar tcal = Calendar.getInstance();
            tcal.setTimeInMillis(ExecutionTimeOfDay);
            Calendar cal = Calendar.getInstance();
            cal.set(10, tcal.get(10));
            cal.set(12, tcal.get(12));
            cal.set(13, tcal.get(13));
            cal.set(14, tcal.get(14));
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] --service(initial)------- calendar ServiceInfo --------------");
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      HOUR_OF_DAY: " + cal.get(11));
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      ZONE_OFFSET: " + cal.get(15));
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]        getTime(): " + cal.getTime());
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] ------------------------- calendar Info ---------------------");
            siPB.setTime(cal);
            siPB.setXmitScheduleSetting(ServiceAgentUtils.getExecutionSetting());
            siPB.setFrequency(ServiceAgentUtils.getExecutionFrequency());
            Trace.trace(TRACE_MASKF, "siPB.getFrequency: " + siPB.getFrequency());
            long PMExecutionTimeOfDay = ServiceAgentUtils.getPMExecutionTimeOfDay();
            Calendar pcal = Calendar.getInstance();
            pcal.setTimeInMillis(PMExecutionTimeOfDay);
            Calendar PMcal = Calendar.getInstance();
            PMcal.set(10, pcal.get(10));
            PMcal.set(12, pcal.get(12));
            PMcal.set(13, pcal.get(13));
            PMcal.set(14, pcal.get(14));
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] --service(initial)------- calendar PMInfo --------------");
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      HOUR_OF_DAY: " + PMcal.get(11));
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      ZONE_OFFSET: " + PMcal.get(15));
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]        getTime(): " + PMcal.getTime());
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] ------------------------- calendar Info ----------------");
            siPB.setPMTime(PMcal);
            siPB.setXmitPMSetting(ServiceAgentUtils.getPMExecutionSetting());
            siPB.setPMFrequency(ServiceAgentUtils.getPMExecutionFrequency());
            Trace.trace(TRACE_MASKF, "siPB.getPMFrequency: " + siPB.getPMFrequency());
            siPB.setBeanName("XMITServiceInfoTransmitPanelBean");
            XMITServiceInfoTransmitTasklet.setControls(siPB);
            ServiceAgentUtils.checkInitialHeartbeat();
            taskletResponse.replace("com.ibm.hwmca.p.sa.res.ServiceAgent", "XMITServiceInfoTransmit", siPB);
        } else {
            this.currentPanel.service(taskletRequest, taskletResponse);
        }
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

